/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;

class VWFieldAddRemovePanel
extends VWAddRemovePanel {
    public static final int FIELDS = 1;
    public static final int ATTACHMENTS = 2;
    public static final int WORKFLOWGROUPS = 4;
    private VWInstructionDefinition m_instructionDef = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private String[] m_availableFields = null;
    private String[] m_selectedFields = null;

    public VWFieldAddRemovePanel(VWAuthPropertyData authPropertyData) {
        super(10);
        this.m_authPropertyData = authPropertyData;
        this.setAvailableItemName(VWResource.s_availableFields);
        this.setSelectedItemName(VWResource.s_selectedFields);
        this.enableSorting(768);
    }

    public void init(VWInstructionDefinition instructionDef, String[] availableFields, String[] selectedFields) {
        try {
            this.m_instructionDef = instructionDef;
            this.m_availableFields = availableFields;
            this.m_selectedFields = selectedFields;
            this.initializeLists(this.m_availableFields, this.m_selectedFields);
            VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
            if (listModel.getSize() > 0) {
                this.m_availableList.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
    }

    public boolean isSelected(String itemName) {
        boolean result;
        block3: {
            result = false;
            try {
                VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
                int selectedListSize = selectedListModel.getSize();
                if (selectedListSize <= 0) break block3;
                for (int i = 0; i < selectedListSize; ++i) {
                    String field = selectedListModel.get(i).toString();
                    if (VWStringUtils.compare(itemName, field) != 0) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return result;
    }

    public String[] getSelectedFields() {
        String[] fields = null;
        try {
            Object[] items = this.m_selectedList.getSelectedValues();
            if (items != null) {
                fields = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    fields[i] = items[i].toString();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return fields;
    }

    public void emptyLists() {
        try {
            this.m_availableList.removeAll();
            this.m_selectedList.removeAll();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void refreshUI() {
        try {
            this.setVisible(false);
            this.setVisible(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addItem(String newField) {
        try {
            VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
            listModel.addElement(newField);
            listModel.sort();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeItem(String itemName) {
        block5: {
            String field = null;
            boolean find = false;
            try {
                VWSortedListModel availableListModel;
                int availableListSize;
                VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
                int selectedListSize = selectedListModel.getSize();
                if (selectedListSize > 0) {
                    for (int i = 0; i < selectedListSize; ++i) {
                        field = selectedListModel.get(i).toString();
                        if (VWStringUtils.compare(itemName, field) != 0) continue;
                        selectedListModel.removeElementAt(i);
                        this.m_authPropertyData.setDirty();
                        find = true;
                        break;
                    }
                }
                if (find || (availableListSize = (availableListModel = (VWSortedListModel)this.m_availableList.getModel()).getSize()) <= 0) break block5;
                for (int i = 0; i < availableListSize; ++i) {
                    field = availableListModel.get(i).toString();
                    if (VWStringUtils.compare(itemName, field) != 0) continue;
                    availableListModel.removeElementAt(i);
                    this.m_authPropertyData.setDirty();
                    find = true;
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void sortLists() {
        try {
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (availableListModel != null) {
                availableListModel.sort();
            }
            if (selectedListModel != null) {
                selectedListModel.sort();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void renameItem(String oldName, String newName) {
        Object param = null;
        Object paramName = null;
        boolean find = false;
        try {
            int listSize;
            VWSortedListModel selectedListModel;
            int listSize2;
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            if (availableListModel != null && (listSize2 = availableListModel.size()) > 0) {
                for (int i = 0; i < listSize2; ++i) {
                    String field = availableListModel.elementAt(i).toString();
                    if (VWStringUtils.compare(oldName, field) != 0) continue;
                    availableListModel.setElementAt(newName, i);
                    find = true;
                    break;
                }
            }
            if (!find && (selectedListModel = (VWSortedListModel)this.m_selectedList.getModel()) != null && (listSize = selectedListModel.size()) > 0) {
                for (int i = 0; i < listSize; ++i) {
                    String field = selectedListModel.elementAt(i).toString();
                    if (VWStringUtils.compare(oldName, field) != 0) continue;
                    selectedListModel.setElementAt(newName, i);
                    find = true;
                    break;
                }
            }
            this.sortLists();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onAddItemsAction(Object[] items) {
        Object[] fields = null;
        try {
            if (this.m_instructionDef != null) {
                DefaultListModel listModel = (DefaultListModel)this.m_availableList.getModel();
                int size = listModel.size();
                if (size > 0) {
                    fields = new String[size];
                    listModel.copyInto(fields);
                }
                VWInstruction.RollBackCheckPointInstructionSetNonRolledBackFieldList(this.m_instructionDef, (String[])fields);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        Object[] fields = null;
        int size = 0;
        try {
            if (this.m_instructionDef != null) {
                int itemSize = items.length;
                DefaultListModel listModel = (DefaultListModel)this.m_availableList.getModel();
                int modelSize = listModel.size();
                size = itemSize + modelSize;
                if (size > 0) {
                    fields = new String[size];
                    listModel.copyInto(fields);
                    if (itemSize > 0) {
                        for (int i = 0; i < itemSize; ++i) {
                            fields[modelSize + i] = items[i].toString();
                        }
                    }
                }
                VWInstruction.RollBackCheckPointInstructionSetNonRolledBackFieldList(this.m_instructionDef, (String[])fields);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }
}

